package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanResourceCriteria(
    include: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition
    ]] = Optional.Absent,
    exclude: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria = {
    import ScanResourceCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria
      .builder()
      .optionallyWith(
        include.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.includeWithStrings)
      .optionallyWith(
        exclude.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.excludeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly =
    zio.aws.guardduty.model.ScanResourceCriteria.wrap(buildAwsValue())
}
object ScanResourceCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanResourceCriteria =
      zio.aws.guardduty.model.ScanResourceCriteria(
        include.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        exclude.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def include: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]]
    def exclude: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]]
    def getInclude: ZIO[Any, AwsError, Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("include", include)
    def getExclude: ZIO[Any, AwsError, Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]] = AwsError.unwrapOptionField("exclude", exclude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria
  ) extends zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly {
    override val include: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.include())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.ScanCriterionKey
              .wrap(key) -> zio.aws.guardduty.model.ScanCondition.wrap(value)
          })
          .toMap
      )
    override val exclude: Optional[Map[
      zio.aws.guardduty.model.ScanCriterionKey,
      zio.aws.guardduty.model.ScanCondition.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.exclude())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.guardduty.model.ScanCriterionKey
              .wrap(key) -> zio.aws.guardduty.model.ScanCondition.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanResourceCriteria
  ): zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly = new Wrapper(impl)
}
