package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait ScanResult {
  def unwrap: software.amazon.awssdk.services.guardduty.model.ScanResult
}
object ScanResult {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.ScanResult
  ): zio.aws.guardduty.model.ScanResult = value match {
    case software.amazon.awssdk.services.guardduty.model.ScanResult.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.ScanResult.CLEAN =>
      val r = CLEAN
      r
    case software.amazon.awssdk.services.guardduty.model.ScanResult.INFECTED =>
      val r = INFECTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.ScanResult {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanResult =
      software.amazon.awssdk.services.guardduty.model.ScanResult.UNKNOWN_TO_SDK_VERSION
  }
  case object CLEAN extends zio.aws.guardduty.model.ScanResult {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanResult =
      software.amazon.awssdk.services.guardduty.model.ScanResult.CLEAN
  }
  case object INFECTED extends zio.aws.guardduty.model.ScanResult {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanResult =
      software.amazon.awssdk.services.guardduty.model.ScanResult.INFECTED
  }
}
