package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ScanResultDetails(
    scanResult: Optional[zio.aws.guardduty.model.ScanResult] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanResultDetails = {
    import ScanResultDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanResultDetails
      .builder()
      .optionallyWith(scanResult.map(value => value.unwrap))(_.scanResult)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanResultDetails.ReadOnly =
    zio.aws.guardduty.model.ScanResultDetails.wrap(buildAwsValue())
}
object ScanResultDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanResultDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanResultDetails =
      zio.aws.guardduty.model.ScanResultDetails(scanResult.map(value => value))
    def scanResult: Optional[zio.aws.guardduty.model.ScanResult]
    def getScanResult: ZIO[Any, AwsError, zio.aws.guardduty.model.ScanResult] =
      AwsError.unwrapOptionField("scanResult", scanResult)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanResultDetails
  ) extends zio.aws.guardduty.model.ScanResultDetails.ReadOnly {
    override val scanResult: Optional[zio.aws.guardduty.model.ScanResult] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanResult())
        .map(value => zio.aws.guardduty.model.ScanResult.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanResultDetails
  ): zio.aws.guardduty.model.ScanResultDetails.ReadOnly = new Wrapper(impl)
}
