package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait ScanStatus {
  def unwrap: software.amazon.awssdk.services.guardduty.model.ScanStatus
}
object ScanStatus {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.ScanStatus
  ): zio.aws.guardduty.model.ScanStatus = value match {
    case software.amazon.awssdk.services.guardduty.model.ScanStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.ScanStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.guardduty.model.ScanStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.guardduty.model.ScanStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.guardduty.model.ScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanStatus =
      software.amazon.awssdk.services.guardduty.model.ScanStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.guardduty.model.ScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanStatus =
      software.amazon.awssdk.services.guardduty.model.ScanStatus.RUNNING
  }
  case object COMPLETED extends zio.aws.guardduty.model.ScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanStatus =
      software.amazon.awssdk.services.guardduty.model.ScanStatus.COMPLETED
  }
  case object FAILED extends zio.aws.guardduty.model.ScanStatus {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ScanStatus =
      software.amazon.awssdk.services.guardduty.model.ScanStatus.FAILED
  }
}
