package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ScanThreatName(
    name: Optional[String] = Optional.Absent,
    severity: Optional[String] = Optional.Absent,
    itemCount: Optional[Integer] = Optional.Absent,
    filePaths: Optional[Iterable[zio.aws.guardduty.model.ScanFilePath]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScanThreatName = {
    import ScanThreatName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScanThreatName
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(severity.map(value => value: java.lang.String))(
        _.severity
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(
        filePaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filePaths)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScanThreatName.ReadOnly =
    zio.aws.guardduty.model.ScanThreatName.wrap(buildAwsValue())
}
object ScanThreatName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScanThreatName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScanThreatName =
      zio.aws.guardduty.model.ScanThreatName(
        name.map(value => value),
        severity.map(value => value),
        itemCount.map(value => value),
        filePaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[String]
    def severity: Optional[String]
    def itemCount: Optional[Integer]
    def filePaths: Optional[List[zio.aws.guardduty.model.ScanFilePath.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("severity", severity)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getFilePaths: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.ScanFilePath.ReadOnly
    ]] = AwsError.unwrapOptionField("filePaths", filePaths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScanThreatName
  ) extends zio.aws.guardduty.model.ScanThreatName.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val severity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.severity())
      .map(value => value: String)
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val filePaths
        : Optional[List[zio.aws.guardduty.model.ScanFilePath.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filePaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.ScanFilePath.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScanThreatName
  ): zio.aws.guardduty.model.ScanThreatName.ReadOnly = new Wrapper(impl)
}
