package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ScannedItemCount(
    totalGb: Optional[Integer] = Optional.Absent,
    files: Optional[Integer] = Optional.Absent,
    volumes: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ScannedItemCount = {
    import ScannedItemCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ScannedItemCount
      .builder()
      .optionallyWith(totalGb.map(value => value: java.lang.Integer))(_.totalGb)
      .optionallyWith(files.map(value => value: java.lang.Integer))(_.files)
      .optionallyWith(volumes.map(value => value: java.lang.Integer))(_.volumes)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ScannedItemCount.ReadOnly =
    zio.aws.guardduty.model.ScannedItemCount.wrap(buildAwsValue())
}
object ScannedItemCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ScannedItemCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ScannedItemCount =
      zio.aws.guardduty.model.ScannedItemCount(
        totalGb.map(value => value),
        files.map(value => value),
        volumes.map(value => value)
      )
    def totalGb: Optional[Integer]
    def files: Optional[Integer]
    def volumes: Optional[Integer]
    def getTotalGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalGb", totalGb)
    def getFiles: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("files", files)
    def getVolumes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumes", volumes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ScannedItemCount
  ) extends zio.aws.guardduty.model.ScannedItemCount.ReadOnly {
    override val totalGb: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.totalGb())
      .map(value => value: Integer)
    override val files: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.files())
      .map(value => value: Integer)
    override val volumes: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumes())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ScannedItemCount
  ): zio.aws.guardduty.model.ScannedItemCount.ReadOnly = new Wrapper(impl)
}
