package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecurityContext(
    privileged: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.SecurityContext = {
    import SecurityContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.SecurityContext
      .builder()
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.SecurityContext.ReadOnly =
    zio.aws.guardduty.model.SecurityContext.wrap(buildAwsValue())
}
object SecurityContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.SecurityContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.SecurityContext =
      zio.aws.guardduty.model.SecurityContext(privileged.map(value => value))
    def privileged: Optional[Boolean]
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.SecurityContext
  ) extends zio.aws.guardduty.model.SecurityContext.ReadOnly {
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.SecurityContext
  ): zio.aws.guardduty.model.SecurityContext.ReadOnly = new Wrapper(impl)
}
