package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SecurityGroup(
    groupId: Optional[String] = Optional.Absent,
    groupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.SecurityGroup = {
    import SecurityGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.SecurityGroup
      .builder()
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.SecurityGroup.ReadOnly =
    zio.aws.guardduty.model.SecurityGroup.wrap(buildAwsValue())
}
object SecurityGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.SecurityGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.SecurityGroup =
      zio.aws.guardduty.model.SecurityGroup(
        groupId.map(value => value),
        groupName.map(value => value)
      )
    def groupId: Optional[String]
    def groupName: Optional[String]
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.SecurityGroup
  ) extends zio.aws.guardduty.model.SecurityGroup.ReadOnly {
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.SecurityGroup
  ): zio.aws.guardduty.model.SecurityGroup.ReadOnly = new Wrapper(impl)
}
