package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{DetectorId, Integer}
import scala.jdk.CollectionConverters.*
final case class Service(
    action: Optional[zio.aws.guardduty.model.Action] = Optional.Absent,
    evidence: Optional[zio.aws.guardduty.model.Evidence] = Optional.Absent,
    archived: Optional[Boolean] = Optional.Absent,
    count: Optional[Integer] = Optional.Absent,
    detectorId: Optional[DetectorId] = Optional.Absent,
    eventFirstSeen: Optional[String] = Optional.Absent,
    eventLastSeen: Optional[String] = Optional.Absent,
    resourceRole: Optional[String] = Optional.Absent,
    serviceName: Optional[String] = Optional.Absent,
    userFeedback: Optional[String] = Optional.Absent,
    additionalInfo: Optional[zio.aws.guardduty.model.ServiceAdditionalInfo] =
      Optional.Absent,
    featureName: Optional[String] = Optional.Absent,
    ebsVolumeScanDetails: Optional[
      zio.aws.guardduty.model.EbsVolumeScanDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Service
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(evidence.map(value => value.buildAwsValue()))(_.evidence)
      .optionallyWith(archived.map(value => value: java.lang.Boolean))(
        _.archived
      )
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .optionallyWith(
        detectorId.map(value => DetectorId.unwrap(value): java.lang.String)
      )(_.detectorId)
      .optionallyWith(eventFirstSeen.map(value => value: java.lang.String))(
        _.eventFirstSeen
      )
      .optionallyWith(eventLastSeen.map(value => value: java.lang.String))(
        _.eventLastSeen
      )
      .optionallyWith(resourceRole.map(value => value: java.lang.String))(
        _.resourceRole
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(userFeedback.map(value => value: java.lang.String))(
        _.userFeedback
      )
      .optionallyWith(additionalInfo.map(value => value.buildAwsValue()))(
        _.additionalInfo
      )
      .optionallyWith(featureName.map(value => value: java.lang.String))(
        _.featureName
      )
      .optionallyWith(ebsVolumeScanDetails.map(value => value.buildAwsValue()))(
        _.ebsVolumeScanDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Service.ReadOnly =
    zio.aws.guardduty.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Service =
      zio.aws.guardduty.model.Service(
        action.map(value => value.asEditable),
        evidence.map(value => value.asEditable),
        archived.map(value => value),
        count.map(value => value),
        detectorId.map(value => value),
        eventFirstSeen.map(value => value),
        eventLastSeen.map(value => value),
        resourceRole.map(value => value),
        serviceName.map(value => value),
        userFeedback.map(value => value),
        additionalInfo.map(value => value.asEditable),
        featureName.map(value => value),
        ebsVolumeScanDetails.map(value => value.asEditable)
      )
    def action: Optional[zio.aws.guardduty.model.Action.ReadOnly]
    def evidence: Optional[zio.aws.guardduty.model.Evidence.ReadOnly]
    def archived: Optional[Boolean]
    def count: Optional[Integer]
    def detectorId: Optional[DetectorId]
    def eventFirstSeen: Optional[String]
    def eventLastSeen: Optional[String]
    def resourceRole: Optional[String]
    def serviceName: Optional[String]
    def userFeedback: Optional[String]
    def additionalInfo
        : Optional[zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly]
    def featureName: Optional[String]
    def ebsVolumeScanDetails
        : Optional[zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly]
    def getAction: ZIO[Any, AwsError, zio.aws.guardduty.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getEvidence
        : ZIO[Any, AwsError, zio.aws.guardduty.model.Evidence.ReadOnly] =
      AwsError.unwrapOptionField("evidence", evidence)
    def getArchived: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("archived", archived)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
    def getDetectorId: ZIO[Any, AwsError, DetectorId] =
      AwsError.unwrapOptionField("detectorId", detectorId)
    def getEventFirstSeen: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventFirstSeen", eventFirstSeen)
    def getEventLastSeen: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eventLastSeen", eventLastSeen)
    def getResourceRole: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceRole", resourceRole)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getUserFeedback: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userFeedback", userFeedback)
    def getAdditionalInfo: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly
    ] = AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getFeatureName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("featureName", featureName)
    def getEbsVolumeScanDetails: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ebsVolumeScanDetails", ebsVolumeScanDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Service
  ) extends zio.aws.guardduty.model.Service.ReadOnly {
    override val action: Optional[zio.aws.guardduty.model.Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.guardduty.model.Action.wrap(value))
    override val evidence: Optional[zio.aws.guardduty.model.Evidence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidence())
        .map(value => zio.aws.guardduty.model.Evidence.wrap(value))
    override val archived: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.archived())
      .map(value => value: Boolean)
    override val count: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => value: Integer)
    override val detectorId: Optional[DetectorId] = zio.aws.core.internal
      .optionalFromNullable(impl.detectorId())
      .map(value => zio.aws.guardduty.model.primitives.DetectorId(value))
    override val eventFirstSeen: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventFirstSeen())
      .map(value => value: String)
    override val eventLastSeen: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eventLastSeen())
      .map(value => value: String)
    override val resourceRole: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceRole())
      .map(value => value: String)
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
    override val userFeedback: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userFeedback())
      .map(value => value: String)
    override val additionalInfo
        : Optional[zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalInfo())
        .map(value => zio.aws.guardduty.model.ServiceAdditionalInfo.wrap(value))
    override val featureName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.featureName())
      .map(value => value: String)
    override val ebsVolumeScanDetails
        : Optional[zio.aws.guardduty.model.EbsVolumeScanDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsVolumeScanDetails())
        .map(value => zio.aws.guardduty.model.EbsVolumeScanDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Service
  ): zio.aws.guardduty.model.Service.ReadOnly = new Wrapper(impl)
}
