package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ServiceAdditionalInfo(
    value: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo = {
    import ServiceAdditionalInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo
      .builder()
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly =
    zio.aws.guardduty.model.ServiceAdditionalInfo.wrap(buildAwsValue())
}
object ServiceAdditionalInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ServiceAdditionalInfo =
      zio.aws.guardduty.model.ServiceAdditionalInfo(
        value.map(value => value),
        `type`.map(value => value)
      )
    def value: Optional[String]
    def `type`: Optional[String]
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo
  ) extends zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly {
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ServiceAdditionalInfo
  ): zio.aws.guardduty.model.ServiceAdditionalInfo.ReadOnly = new Wrapper(impl)
}
