package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartMonitoringMembersResponse(
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse = {
    import StartMonitoringMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse
      .builder()
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly =
    zio.aws.guardduty.model.StartMonitoringMembersResponse.wrap(buildAwsValue())
}
object StartMonitoringMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.StartMonitoringMembersResponse =
      zio.aws.guardduty.model
        .StartMonitoringMembersResponse(unprocessedAccounts.map { item =>
          item.asEditable
        })
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse
  ) extends zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly {
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.StartMonitoringMembersResponse
  ): zio.aws.guardduty.model.StartMonitoringMembersResponse.ReadOnly =
    new Wrapper(impl)
}
