package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{TagValue, TagKey, GuardDutyArn}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: GuardDutyArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.TagResourceRequest
      .builder()
      .resourceArn(GuardDutyArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.TagResourceRequest.ReadOnly =
    zio.aws.guardduty.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.TagResourceRequest =
      zio.aws.guardduty.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: GuardDutyArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, GuardDutyArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.TagResourceRequest
  ) extends zio.aws.guardduty.model.TagResourceRequest.ReadOnly {
    override val resourceArn: GuardDutyArn =
      zio.aws.guardduty.model.primitives.GuardDutyArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.guardduty.model.primitives
          .TagKey(key) -> zio.aws.guardduty.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.TagResourceRequest
  ): zio.aws.guardduty.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
