package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ThreatDetectedByName(
    itemCount: Optional[Integer] = Optional.Absent,
    uniqueThreatNameCount: Optional[Integer] = Optional.Absent,
    shortened: Optional[Boolean] = Optional.Absent,
    threatNames: Optional[Iterable[zio.aws.guardduty.model.ScanThreatName]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName = {
    import ThreatDetectedByName.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName
      .builder()
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(
        uniqueThreatNameCount.map(value => value: java.lang.Integer)
      )(_.uniqueThreatNameCount)
      .optionallyWith(shortened.map(value => value: java.lang.Boolean))(
        _.shortened
      )
      .optionallyWith(
        threatNames.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.threatNames)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly =
    zio.aws.guardduty.model.ThreatDetectedByName.wrap(buildAwsValue())
}
object ThreatDetectedByName {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ThreatDetectedByName =
      zio.aws.guardduty.model.ThreatDetectedByName(
        itemCount.map(value => value),
        uniqueThreatNameCount.map(value => value),
        shortened.map(value => value),
        threatNames.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def itemCount: Optional[Integer]
    def uniqueThreatNameCount: Optional[Integer]
    def shortened: Optional[Boolean]
    def threatNames
        : Optional[List[zio.aws.guardduty.model.ScanThreatName.ReadOnly]]
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getUniqueThreatNameCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("uniqueThreatNameCount", uniqueThreatNameCount)
    def getShortened: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("shortened", shortened)
    def getThreatNames: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.ScanThreatName.ReadOnly
    ]] = AwsError.unwrapOptionField("threatNames", threatNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName
  ) extends zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly {
    override val itemCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.itemCount())
      .map(value => value: Integer)
    override val uniqueThreatNameCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.uniqueThreatNameCount())
        .map(value => value: Integer)
    override val shortened: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.shortened())
      .map(value => value: Boolean)
    override val threatNames
        : Optional[List[zio.aws.guardduty.model.ScanThreatName.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.threatNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.ScanThreatName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatDetectedByName
  ): zio.aws.guardduty.model.ThreatDetectedByName.ReadOnly = new Wrapper(impl)
}
