package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait ThreatIntelSetFormat {
  def unwrap
      : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat
}
object ThreatIntelSetFormat {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat
  ): zio.aws.guardduty.model.ThreatIntelSetFormat = value match {
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.TXT =>
      val r = TXT
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.STIX =>
      val r = STIX
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.OTX_CSV =>
      val r = OTX_CSV
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.ALIEN_VAULT =>
      val r = ALIEN_VAULT
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.PROOF_POINT =>
      val r = PROOF_POINT
      r
    case software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.FIRE_EYE =>
      val r = FIRE_EYE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object TXT extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.TXT
  }
  case object STIX extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.STIX
  }
  case object OTX_CSV extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.OTX_CSV
  }
  case object ALIEN_VAULT extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.ALIEN_VAULT
  }
  case object PROOF_POINT extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.PROOF_POINT
  }
  case object FIRE_EYE extends zio.aws.guardduty.model.ThreatIntelSetFormat {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat =
      software.amazon.awssdk.services.guardduty.model.ThreatIntelSetFormat.FIRE_EYE
  }
}
