package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThreatIntelligenceDetail(
    threatListName: Optional[String] = Optional.Absent,
    threatNames: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail = {
    import ThreatIntelligenceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail
      .builder()
      .optionallyWith(threatListName.map(value => value: java.lang.String))(
        _.threatListName
      )
      .optionallyWith(
        threatNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.threatNames)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly =
    zio.aws.guardduty.model.ThreatIntelligenceDetail.wrap(buildAwsValue())
}
object ThreatIntelligenceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ThreatIntelligenceDetail =
      zio.aws.guardduty.model.ThreatIntelligenceDetail(
        threatListName.map(value => value),
        threatNames.map(value => value)
      )
    def threatListName: Optional[String]
    def threatNames: Optional[List[String]]
    def getThreatListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("threatListName", threatListName)
    def getThreatNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("threatNames", threatNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail
  ) extends zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly {
    override val threatListName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.threatListName())
      .map(value => value: String)
    override val threatNames: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.threatNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatIntelligenceDetail
  ): zio.aws.guardduty.model.ThreatIntelligenceDetail.ReadOnly = new Wrapper(
    impl
  )
}
