package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class ThreatsDetectedItemCount(
    files: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount = {
    import ThreatsDetectedItemCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount
      .builder()
      .optionallyWith(files.map(value => value: java.lang.Integer))(_.files)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly =
    zio.aws.guardduty.model.ThreatsDetectedItemCount.wrap(buildAwsValue())
}
object ThreatsDetectedItemCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.ThreatsDetectedItemCount =
      zio.aws.guardduty.model
        .ThreatsDetectedItemCount(files.map(value => value))
    def files: Optional[Integer]
    def getFiles: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("files", files)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount
  ) extends zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly {
    override val files: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.files())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.ThreatsDetectedItemCount
  ): zio.aws.guardduty.model.ThreatsDetectedItemCount.ReadOnly = new Wrapper(
    impl
  )
}
