package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Total(
    amount: Optional[String] = Optional.Absent,
    unit: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.guardduty.model.Total = {
    import Total.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Total
      .builder()
      .optionallyWith(amount.map(value => value: java.lang.String))(_.amount)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Total.ReadOnly =
    zio.aws.guardduty.model.Total.wrap(buildAwsValue())
}
object Total {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Total] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Total = zio.aws.guardduty.model
      .Total(amount.map(value => value), unit.map(value => value))
    def amount: Optional[String]
    def unit: Optional[String]
    def getAmount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("amount", amount)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Total
  ) extends zio.aws.guardduty.model.Total.ReadOnly {
    override val amount: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.amount())
      .map(value => value: String)
    override val unit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Total
  ): zio.aws.guardduty.model.Total.ReadOnly = new Wrapper(impl)
}
