package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class TriggerDetails(
    guardDutyFindingId: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.TriggerDetails = {
    import TriggerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.TriggerDetails
      .builder()
      .optionallyWith(
        guardDutyFindingId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.guardDutyFindingId)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.TriggerDetails.ReadOnly =
    zio.aws.guardduty.model.TriggerDetails.wrap(buildAwsValue())
}
object TriggerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.TriggerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.TriggerDetails =
      zio.aws.guardduty.model.TriggerDetails(
        guardDutyFindingId.map(value => value),
        description.map(value => value)
      )
    def guardDutyFindingId: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def getGuardDutyFindingId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("guardDutyFindingId", guardDutyFindingId)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.TriggerDetails
  ) extends zio.aws.guardduty.model.TriggerDetails.ReadOnly {
    override val guardDutyFindingId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardDutyFindingId())
        .map(value => zio.aws.guardduty.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.guardduty.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.TriggerDetails
  ): zio.aws.guardduty.model.TriggerDetails.ReadOnly = new Wrapper(impl)
}
