package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{FindingId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class UnarchiveFindingsRequest(
    detectorId: DetectorId,
    findingIds: Iterable[FindingId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest = {
    import UnarchiveFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .findingIds(findingIds.map { item =>
        FindingId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UnarchiveFindingsRequest.ReadOnly =
    zio.aws.guardduty.model.UnarchiveFindingsRequest.wrap(buildAwsValue())
}
object UnarchiveFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UnarchiveFindingsRequest =
      zio.aws.guardduty.model.UnarchiveFindingsRequest(detectorId, findingIds)
    def detectorId: DetectorId
    def findingIds: List[FindingId]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingIds: ZIO[Any, Nothing, List[FindingId]] =
      ZIO.succeed(findingIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest
  ) extends zio.aws.guardduty.model.UnarchiveFindingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingIds: List[FindingId] = impl
      .findingIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.FindingId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UnarchiveFindingsRequest
  ): zio.aws.guardduty.model.UnarchiveFindingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
