package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class UnprocessedAccount(accountId: AccountId, result: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UnprocessedAccount = {
    import UnprocessedAccount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UnprocessedAccount
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .result(result: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UnprocessedAccount.ReadOnly =
    zio.aws.guardduty.model.UnprocessedAccount.wrap(buildAwsValue())
}
object UnprocessedAccount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UnprocessedAccount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UnprocessedAccount =
      zio.aws.guardduty.model.UnprocessedAccount(accountId, result)
    def accountId: AccountId
    def result: String
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getResult: ZIO[Any, Nothing, String] = ZIO.succeed(result)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UnprocessedAccount
  ) extends zio.aws.guardduty.model.UnprocessedAccount.ReadOnly {
    override val accountId: AccountId =
      zio.aws.guardduty.model.primitives.AccountId(impl.accountId())
    override val result: String = impl.result(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UnprocessedAccount
  ): zio.aws.guardduty.model.UnprocessedAccount.ReadOnly = new Wrapper(impl)
}
