package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.{TagKey, GuardDutyArn}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: GuardDutyArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UntagResourceRequest
      .builder()
      .resourceArn(GuardDutyArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UntagResourceRequest.ReadOnly =
    zio.aws.guardduty.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UntagResourceRequest =
      zio.aws.guardduty.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: GuardDutyArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, GuardDutyArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UntagResourceRequest
  ) extends zio.aws.guardduty.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: GuardDutyArn =
      zio.aws.guardduty.model.primitives.GuardDutyArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UntagResourceRequest
  ): zio.aws.guardduty.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
