package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class UpdateDetectorRequest(
    detectorId: DetectorId,
    enable: Optional[Boolean] = Optional.Absent,
    findingPublishingFrequency: Optional[
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = Optional.Absent,
    dataSources: Optional[zio.aws.guardduty.model.DataSourceConfigurations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest = {
    import UpdateDetectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(enable.map(value => value: java.lang.Boolean))(_.enable)
      .optionallyWith(findingPublishingFrequency.map(value => value.unwrap))(
        _.findingPublishingFrequency
      )
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UpdateDetectorRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateDetectorRequest.wrap(buildAwsValue())
}
object UpdateDetectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateDetectorRequest =
      zio.aws.guardduty.model.UpdateDetectorRequest(
        detectorId,
        enable.map(value => value),
        findingPublishingFrequency.map(value => value),
        dataSources.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def enable: Optional[Boolean]
    def findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency]
    def dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getEnable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enable", enable)
    def getFindingPublishingFrequency: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.FindingPublishingFrequency
    ] = AwsError.unwrapOptionField(
      "findingPublishingFrequency",
      findingPublishingFrequency
    )
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest
  ) extends zio.aws.guardduty.model.UpdateDetectorRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val enable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enable())
      .map(value => value: Boolean)
    override val findingPublishingFrequency
        : Optional[zio.aws.guardduty.model.FindingPublishingFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingPublishingFrequency())
        .map(value =>
          zio.aws.guardduty.model.FindingPublishingFrequency.wrap(value)
        )
    override val dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          zio.aws.guardduty.model.DataSourceConfigurations.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateDetectorRequest
  ): zio.aws.guardduty.model.UpdateDetectorRequest.ReadOnly = new Wrapper(impl)
}
