package zio.aws.guardduty.model
import zio.aws.guardduty.model.primitives.{
  FilterRank,
  FilterDescription,
  DetectorId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateFilterRequest(
    detectorId: DetectorId,
    filterName: String,
    description: Optional[FilterDescription] = Optional.Absent,
    action: Optional[zio.aws.guardduty.model.FilterAction] = Optional.Absent,
    rank: Optional[FilterRank] = Optional.Absent,
    findingCriteria: Optional[zio.aws.guardduty.model.FindingCriteria] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest = {
    import UpdateFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .filterName(filterName: java.lang.String)
      .optionallyWith(
        description.map(value =>
          FilterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(rank.map(value => FilterRank.unwrap(value): Integer))(
        _.rank
      )
      .optionallyWith(findingCriteria.map(value => value.buildAwsValue()))(
        _.findingCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UpdateFilterRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateFilterRequest.wrap(buildAwsValue())
}
object UpdateFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateFilterRequest =
      zio.aws.guardduty.model.UpdateFilterRequest(
        detectorId,
        filterName,
        description.map(value => value),
        action.map(value => value),
        rank.map(value => value),
        findingCriteria.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def filterName: String
    def description: Optional[FilterDescription]
    def action: Optional[zio.aws.guardduty.model.FilterAction]
    def rank: Optional[FilterRank]
    def findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFilterName: ZIO[Any, Nothing, String] = ZIO.succeed(filterName)
    def getDescription: ZIO[Any, AwsError, FilterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAction: ZIO[Any, AwsError, zio.aws.guardduty.model.FilterAction] =
      AwsError.unwrapOptionField("action", action)
    def getRank: ZIO[Any, AwsError, FilterRank] =
      AwsError.unwrapOptionField("rank", rank)
    def getFindingCriteria
        : ZIO[Any, AwsError, zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      AwsError.unwrapOptionField("findingCriteria", findingCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest
  ) extends zio.aws.guardduty.model.UpdateFilterRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val filterName: String = impl.filterName(): String
    override val description: Optional[FilterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.guardduty.model.primitives.FilterDescription(value)
        )
    override val action: Optional[zio.aws.guardduty.model.FilterAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.guardduty.model.FilterAction.wrap(value))
    override val rank: Optional[FilterRank] = zio.aws.core.internal
      .optionalFromNullable(impl.rank())
      .map(value => zio.aws.guardduty.model.primitives.FilterRank(value))
    override val findingCriteria
        : Optional[zio.aws.guardduty.model.FindingCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingCriteria())
        .map(value => zio.aws.guardduty.model.FindingCriteria.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFilterRequest
  ): zio.aws.guardduty.model.UpdateFilterRequest.ReadOnly = new Wrapper(impl)
}
