package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.guardduty.model.primitives.FilterName
import scala.jdk.CollectionConverters.*
final case class UpdateFilterResponse(name: FilterName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse = {
    import UpdateFilterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly =
    zio.aws.guardduty.model.UpdateFilterResponse.wrap(buildAwsValue())
}
object UpdateFilterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateFilterResponse =
      zio.aws.guardduty.model.UpdateFilterResponse(name)
    def name: FilterName
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse
  ) extends zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly {
    override val name: FilterName =
      zio.aws.guardduty.model.primitives.FilterName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFilterResponse
  ): zio.aws.guardduty.model.UpdateFilterResponse.ReadOnly = new Wrapper(impl)
}
