package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{FindingId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class UpdateFindingsFeedbackRequest(
    detectorId: DetectorId,
    findingIds: Iterable[FindingId],
    feedback: zio.aws.guardduty.model.Feedback,
    comments: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest = {
    import UpdateFindingsFeedbackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .findingIds(findingIds.map { item =>
        FindingId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .feedback(feedback.unwrap)
      .optionallyWith(comments.map(value => value: java.lang.String))(
        _.comments
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdateFindingsFeedbackRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateFindingsFeedbackRequest.wrap(buildAwsValue())
}
object UpdateFindingsFeedbackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateFindingsFeedbackRequest =
      zio.aws.guardduty.model.UpdateFindingsFeedbackRequest(
        detectorId,
        findingIds,
        feedback,
        comments.map(value => value)
      )
    def detectorId: DetectorId
    def findingIds: List[FindingId]
    def feedback: zio.aws.guardduty.model.Feedback
    def comments: Optional[String]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getFindingIds: ZIO[Any, Nothing, List[FindingId]] =
      ZIO.succeed(findingIds)
    def getFeedback: ZIO[Any, Nothing, zio.aws.guardduty.model.Feedback] =
      ZIO.succeed(feedback)
    def getComments: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comments", comments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest
  ) extends zio.aws.guardduty.model.UpdateFindingsFeedbackRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val findingIds: List[FindingId] = impl
      .findingIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.FindingId(item)
      }
      .toList
    override val feedback: zio.aws.guardduty.model.Feedback =
      zio.aws.guardduty.model.Feedback.wrap(impl.feedback())
    override val comments: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comments())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateFindingsFeedbackRequest
  ): zio.aws.guardduty.model.UpdateFindingsFeedbackRequest.ReadOnly =
    new Wrapper(impl)
}
