package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{Location, Name, DetectorId}
import scala.jdk.CollectionConverters.*
final case class UpdateIpSetRequest(
    detectorId: DetectorId,
    ipSetId: String,
    name: Optional[Name] = Optional.Absent,
    location: Optional[Location] = Optional.Absent,
    activate: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest = {
    import UpdateIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .ipSetId(ipSetId: java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(activate.map(value => value: java.lang.Boolean))(
        _.activate
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UpdateIpSetRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateIpSetRequest.wrap(buildAwsValue())
}
object UpdateIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateIpSetRequest =
      zio.aws.guardduty.model.UpdateIpSetRequest(
        detectorId,
        ipSetId,
        name.map(value => value),
        location.map(value => value),
        activate.map(value => value)
      )
    def detectorId: DetectorId
    def ipSetId: String
    def name: Optional[Name]
    def location: Optional[Location]
    def activate: Optional[Boolean]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getIpSetId: ZIO[Any, Nothing, String] = ZIO.succeed(ipSetId)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
    def getActivate: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("activate", activate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest
  ) extends zio.aws.guardduty.model.UpdateIpSetRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val ipSetId: String = impl.ipSetId(): String
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.guardduty.model.primitives.Name(value))
    override val location: Optional[Location] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.guardduty.model.primitives.Location(value))
    override val activate: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.activate())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateIpSetRequest
  ): zio.aws.guardduty.model.UpdateIpSetRequest.ReadOnly = new Wrapper(impl)
}
