package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class UpdateMalwareScanSettingsRequest(
    detectorId: DetectorId,
    scanResourceCriteria: Optional[
      zio.aws.guardduty.model.ScanResourceCriteria
    ] = Optional.Absent,
    ebsSnapshotPreservation: Optional[
      zio.aws.guardduty.model.EbsSnapshotPreservation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest = {
    import UpdateMalwareScanSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .optionallyWith(scanResourceCriteria.map(value => value.buildAwsValue()))(
        _.scanResourceCriteria
      )
      .optionallyWith(ebsSnapshotPreservation.map(value => value.unwrap))(
        _.ebsSnapshotPreservation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateMalwareScanSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest =
      zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest(
        detectorId,
        scanResourceCriteria.map(value => value.asEditable),
        ebsSnapshotPreservation.map(value => value)
      )
    def detectorId: DetectorId
    def scanResourceCriteria
        : Optional[zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly]
    def ebsSnapshotPreservation
        : Optional[zio.aws.guardduty.model.EbsSnapshotPreservation]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getScanResourceCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly
    ] = AwsError.unwrapOptionField("scanResourceCriteria", scanResourceCriteria)
    def getEbsSnapshotPreservation
        : ZIO[Any, AwsError, zio.aws.guardduty.model.EbsSnapshotPreservation] =
      AwsError.unwrapOptionField(
        "ebsSnapshotPreservation",
        ebsSnapshotPreservation
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest
  ) extends zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val scanResourceCriteria
        : Optional[zio.aws.guardduty.model.ScanResourceCriteria.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scanResourceCriteria())
        .map(value => zio.aws.guardduty.model.ScanResourceCriteria.wrap(value))
    override val ebsSnapshotPreservation
        : Optional[zio.aws.guardduty.model.EbsSnapshotPreservation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsSnapshotPreservation())
        .map(value =>
          zio.aws.guardduty.model.EbsSnapshotPreservation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMalwareScanSettingsRequest
  ): zio.aws.guardduty.model.UpdateMalwareScanSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
