package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.{AccountId, DetectorId}
import scala.jdk.CollectionConverters.*
final case class UpdateMemberDetectorsRequest(
    detectorId: DetectorId,
    accountIds: Iterable[AccountId],
    dataSources: Optional[zio.aws.guardduty.model.DataSourceConfigurations] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest = {
    import UpdateMemberDetectorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdateMemberDetectorsRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateMemberDetectorsRequest.wrap(buildAwsValue())
}
object UpdateMemberDetectorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateMemberDetectorsRequest =
      zio.aws.guardduty.model.UpdateMemberDetectorsRequest(
        detectorId,
        accountIds,
        dataSources.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def accountIds: List[AccountId]
    def dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest
  ) extends zio.aws.guardduty.model.UpdateMemberDetectorsRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.primitives.AccountId(item)
      }
      .toList
    override val dataSources
        : Optional[zio.aws.guardduty.model.DataSourceConfigurations.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSources())
        .map(value =>
          zio.aws.guardduty.model.DataSourceConfigurations.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsRequest
  ): zio.aws.guardduty.model.UpdateMemberDetectorsRequest.ReadOnly =
    new Wrapper(impl)
}
