package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateMemberDetectorsResponse(
    unprocessedAccounts: Iterable[zio.aws.guardduty.model.UnprocessedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse = {
    import UpdateMemberDetectorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse
      .builder()
      .unprocessedAccounts(unprocessedAccounts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly =
    zio.aws.guardduty.model.UpdateMemberDetectorsResponse.wrap(buildAwsValue())
}
object UpdateMemberDetectorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdateMemberDetectorsResponse =
      zio.aws.guardduty.model
        .UpdateMemberDetectorsResponse(unprocessedAccounts.map { item =>
          item.asEditable
        })
    def unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly]
    def getUnprocessedAccounts: ZIO[Any, Nothing, List[
      zio.aws.guardduty.model.UnprocessedAccount.ReadOnly
    ]] = ZIO.succeed(unprocessedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse
  ) extends zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly {
    override val unprocessedAccounts
        : List[zio.aws.guardduty.model.UnprocessedAccount.ReadOnly] = impl
      .unprocessedAccounts()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.UnprocessedAccount.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateMemberDetectorsResponse
  ): zio.aws.guardduty.model.UpdateMemberDetectorsResponse.ReadOnly =
    new Wrapper(impl)
}
