package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class UpdateOrganizationConfigurationRequest(
    detectorId: DetectorId,
    autoEnable: Boolean,
    dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurations
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest = {
    import UpdateOrganizationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .autoEnable(autoEnable: java.lang.Boolean)
      .optionallyWith(dataSources.map(value => value.buildAwsValue()))(
        _.dataSources
      )
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateOrganizationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest =
      zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest(
        detectorId,
        autoEnable,
        dataSources.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def autoEnable: Boolean
    def dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly
    ]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getAutoEnable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(autoEnable)
    def getDataSources: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("dataSources", dataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest
  ) extends zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val autoEnable: Boolean = impl.autoEnable(): Boolean
    override val dataSources: Optional[
      zio.aws.guardduty.model.OrganizationDataSourceConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSources())
      .map(value =>
        zio.aws.guardduty.model.OrganizationDataSourceConfigurations.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdateOrganizationConfigurationRequest
  ): zio.aws.guardduty.model.UpdateOrganizationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
