package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.DetectorId
import scala.jdk.CollectionConverters.*
final case class UpdatePublishingDestinationRequest(
    detectorId: DetectorId,
    destinationId: String,
    destinationProperties: Optional[
      zio.aws.guardduty.model.DestinationProperties
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest = {
    import UpdatePublishingDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest
      .builder()
      .detectorId(DetectorId.unwrap(detectorId): java.lang.String)
      .destinationId(destinationId: java.lang.String)
      .optionallyWith(
        destinationProperties.map(value => value.buildAwsValue())
      )(_.destinationProperties)
      .build()
  }
  def asReadOnly
      : zio.aws.guardduty.model.UpdatePublishingDestinationRequest.ReadOnly =
    zio.aws.guardduty.model.UpdatePublishingDestinationRequest
      .wrap(buildAwsValue())
}
object UpdatePublishingDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UpdatePublishingDestinationRequest =
      zio.aws.guardduty.model.UpdatePublishingDestinationRequest(
        detectorId,
        destinationId,
        destinationProperties.map(value => value.asEditable)
      )
    def detectorId: DetectorId
    def destinationId: String
    def destinationProperties
        : Optional[zio.aws.guardduty.model.DestinationProperties.ReadOnly]
    def getDetectorId: ZIO[Any, Nothing, DetectorId] = ZIO.succeed(detectorId)
    def getDestinationId: ZIO[Any, Nothing, String] = ZIO.succeed(destinationId)
    def getDestinationProperties: ZIO[
      Any,
      AwsError,
      zio.aws.guardduty.model.DestinationProperties.ReadOnly
    ] =
      AwsError.unwrapOptionField("destinationProperties", destinationProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest
  ) extends zio.aws.guardduty.model.UpdatePublishingDestinationRequest.ReadOnly {
    override val detectorId: DetectorId =
      zio.aws.guardduty.model.primitives.DetectorId(impl.detectorId())
    override val destinationId: String = impl.destinationId(): String
    override val destinationProperties
        : Optional[zio.aws.guardduty.model.DestinationProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationProperties())
        .map(value => zio.aws.guardduty.model.DestinationProperties.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UpdatePublishingDestinationRequest
  ): zio.aws.guardduty.model.UpdatePublishingDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
