package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class UsageAccountResult(
    accountId: Optional[AccountId] = Optional.Absent,
    total: Optional[zio.aws.guardduty.model.Total] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UsageAccountResult = {
    import UsageAccountResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UsageAccountResult
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UsageAccountResult.ReadOnly =
    zio.aws.guardduty.model.UsageAccountResult.wrap(buildAwsValue())
}
object UsageAccountResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UsageAccountResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UsageAccountResult =
      zio.aws.guardduty.model.UsageAccountResult(
        accountId.map(value => value),
        total.map(value => value.asEditable)
      )
    def accountId: Optional[AccountId]
    def total: Optional[zio.aws.guardduty.model.Total.ReadOnly]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getTotal: ZIO[Any, AwsError, zio.aws.guardduty.model.Total.ReadOnly] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UsageAccountResult
  ) extends zio.aws.guardduty.model.UsageAccountResult.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.guardduty.model.primitives.AccountId(value))
    override val total: Optional[zio.aws.guardduty.model.Total.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.total())
        .map(value => zio.aws.guardduty.model.Total.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UsageAccountResult
  ): zio.aws.guardduty.model.UsageAccountResult.ReadOnly = new Wrapper(impl)
}
