package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class UsageCriteria(
    accountIds: Optional[Iterable[AccountId]] = Optional.Absent,
    dataSources: Iterable[zio.aws.guardduty.model.DataSource],
    resources: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UsageCriteria = {
    import UsageCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UsageCriteria
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .dataSourcesWithStrings(dataSources.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UsageCriteria.ReadOnly =
    zio.aws.guardduty.model.UsageCriteria.wrap(buildAwsValue())
}
object UsageCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UsageCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UsageCriteria =
      zio.aws.guardduty.model.UsageCriteria(
        accountIds.map(value => value),
        dataSources,
        resources.map(value => value)
      )
    def accountIds: Optional[List[AccountId]]
    def dataSources: List[zio.aws.guardduty.model.DataSource]
    def resources: Optional[List[String]]
    def getAccountIds: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getDataSources
        : ZIO[Any, Nothing, List[zio.aws.guardduty.model.DataSource]] =
      ZIO.succeed(dataSources)
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UsageCriteria
  ) extends zio.aws.guardduty.model.UsageCriteria.ReadOnly {
    override val accountIds: Optional[List[AccountId]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.primitives.AccountId(item)
        }.toList
      )
    override val dataSources: List[zio.aws.guardduty.model.DataSource] = impl
      .dataSources()
      .asScala
      .map { item =>
        zio.aws.guardduty.model.DataSource.wrap(item)
      }
      .toList
    override val resources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UsageCriteria
  ): zio.aws.guardduty.model.UsageCriteria.ReadOnly = new Wrapper(impl)
}
