package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UsageDataSourceResult(
    dataSource: Optional[zio.aws.guardduty.model.DataSource] = Optional.Absent,
    total: Optional[zio.aws.guardduty.model.Total] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult = {
    import UsageDataSourceResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult
      .builder()
      .optionallyWith(dataSource.map(value => value.unwrap))(_.dataSource)
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly =
    zio.aws.guardduty.model.UsageDataSourceResult.wrap(buildAwsValue())
}
object UsageDataSourceResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UsageDataSourceResult =
      zio.aws.guardduty.model.UsageDataSourceResult(
        dataSource.map(value => value),
        total.map(value => value.asEditable)
      )
    def dataSource: Optional[zio.aws.guardduty.model.DataSource]
    def total: Optional[zio.aws.guardduty.model.Total.ReadOnly]
    def getDataSource: ZIO[Any, AwsError, zio.aws.guardduty.model.DataSource] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getTotal: ZIO[Any, AwsError, zio.aws.guardduty.model.Total.ReadOnly] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult
  ) extends zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly {
    override val dataSource: Optional[zio.aws.guardduty.model.DataSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.guardduty.model.DataSource.wrap(value))
    override val total: Optional[zio.aws.guardduty.model.Total.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.total())
        .map(value => zio.aws.guardduty.model.Total.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UsageDataSourceResult
  ): zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly = new Wrapper(impl)
}
