package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UsageResourceResult(
    resource: Optional[String] = Optional.Absent,
    total: Optional[zio.aws.guardduty.model.Total] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UsageResourceResult = {
    import UsageResourceResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UsageResourceResult
      .builder()
      .optionallyWith(resource.map(value => value: java.lang.String))(
        _.resource
      )
      .optionallyWith(total.map(value => value.buildAwsValue()))(_.total)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UsageResourceResult.ReadOnly =
    zio.aws.guardduty.model.UsageResourceResult.wrap(buildAwsValue())
}
object UsageResourceResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UsageResourceResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UsageResourceResult =
      zio.aws.guardduty.model.UsageResourceResult(
        resource.map(value => value),
        total.map(value => value.asEditable)
      )
    def resource: Optional[String]
    def total: Optional[zio.aws.guardduty.model.Total.ReadOnly]
    def getResource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resource", resource)
    def getTotal: ZIO[Any, AwsError, zio.aws.guardduty.model.Total.ReadOnly] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UsageResourceResult
  ) extends zio.aws.guardduty.model.UsageResourceResult.ReadOnly {
    override val resource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value => value: String)
    override val total: Optional[zio.aws.guardduty.model.Total.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.total())
        .map(value => zio.aws.guardduty.model.Total.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UsageResourceResult
  ): zio.aws.guardduty.model.UsageResourceResult.ReadOnly = new Wrapper(impl)
}
