package zio.aws.guardduty.model
import scala.jdk.CollectionConverters.*
sealed trait UsageStatisticType {
  def unwrap: software.amazon.awssdk.services.guardduty.model.UsageStatisticType
}
object UsageStatisticType {
  def wrap(
      value: software.amazon.awssdk.services.guardduty.model.UsageStatisticType
  ): zio.aws.guardduty.model.UsageStatisticType = value match {
    case software.amazon.awssdk.services.guardduty.model.UsageStatisticType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_ACCOUNT =>
      val r = SUM_BY_ACCOUNT
      r
    case software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_DATA_SOURCE =>
      val r = SUM_BY_DATA_SOURCE
      r
    case software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_RESOURCE =>
      val r = SUM_BY_RESOURCE
      r
    case software.amazon.awssdk.services.guardduty.model.UsageStatisticType.TOP_RESOURCES =>
      val r = TOP_RESOURCES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.guardduty.model.UsageStatisticType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.UsageStatisticType =
      software.amazon.awssdk.services.guardduty.model.UsageStatisticType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUM_BY_ACCOUNT
      extends zio.aws.guardduty.model.UsageStatisticType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.UsageStatisticType =
      software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_ACCOUNT
  }
  case object SUM_BY_DATA_SOURCE
      extends zio.aws.guardduty.model.UsageStatisticType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.UsageStatisticType =
      software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_DATA_SOURCE
  }
  case object SUM_BY_RESOURCE
      extends zio.aws.guardduty.model.UsageStatisticType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.UsageStatisticType =
      software.amazon.awssdk.services.guardduty.model.UsageStatisticType.SUM_BY_RESOURCE
  }
  case object TOP_RESOURCES extends zio.aws.guardduty.model.UsageStatisticType {
    override def unwrap
        : software.amazon.awssdk.services.guardduty.model.UsageStatisticType =
      software.amazon.awssdk.services.guardduty.model.UsageStatisticType.TOP_RESOURCES
  }
}
