package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UsageStatistics(
    sumByAccount: Optional[
      Iterable[zio.aws.guardduty.model.UsageAccountResult]
    ] = Optional.Absent,
    sumByDataSource: Optional[
      Iterable[zio.aws.guardduty.model.UsageDataSourceResult]
    ] = Optional.Absent,
    sumByResource: Optional[
      Iterable[zio.aws.guardduty.model.UsageResourceResult]
    ] = Optional.Absent,
    topResources: Optional[
      Iterable[zio.aws.guardduty.model.UsageResourceResult]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.UsageStatistics = {
    import UsageStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.UsageStatistics
      .builder()
      .optionallyWith(
        sumByAccount.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sumByAccount)
      .optionallyWith(
        sumByDataSource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sumByDataSource)
      .optionallyWith(
        sumByResource.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sumByResource)
      .optionallyWith(
        topResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topResources)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.UsageStatistics.ReadOnly =
    zio.aws.guardduty.model.UsageStatistics.wrap(buildAwsValue())
}
object UsageStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.UsageStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.UsageStatistics =
      zio.aws.guardduty.model.UsageStatistics(
        sumByAccount.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sumByDataSource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sumByResource.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        topResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sumByAccount
        : Optional[List[zio.aws.guardduty.model.UsageAccountResult.ReadOnly]]
    def sumByDataSource
        : Optional[List[zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly]]
    def sumByResource
        : Optional[List[zio.aws.guardduty.model.UsageResourceResult.ReadOnly]]
    def topResources
        : Optional[List[zio.aws.guardduty.model.UsageResourceResult.ReadOnly]]
    def getSumByAccount: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.UsageAccountResult.ReadOnly
    ]] = AwsError.unwrapOptionField("sumByAccount", sumByAccount)
    def getSumByDataSource: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly
    ]] = AwsError.unwrapOptionField("sumByDataSource", sumByDataSource)
    def getSumByResource: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.UsageResourceResult.ReadOnly
    ]] = AwsError.unwrapOptionField("sumByResource", sumByResource)
    def getTopResources: ZIO[Any, AwsError, List[
      zio.aws.guardduty.model.UsageResourceResult.ReadOnly
    ]] = AwsError.unwrapOptionField("topResources", topResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.UsageStatistics
  ) extends zio.aws.guardduty.model.UsageStatistics.ReadOnly {
    override val sumByAccount
        : Optional[List[zio.aws.guardduty.model.UsageAccountResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sumByAccount())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.UsageAccountResult.wrap(item)
          }.toList
        )
    override val sumByDataSource: Optional[
      List[zio.aws.guardduty.model.UsageDataSourceResult.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sumByDataSource())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.guardduty.model.UsageDataSourceResult.wrap(item)
        }.toList
      )
    override val sumByResource
        : Optional[List[zio.aws.guardduty.model.UsageResourceResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sumByResource())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.UsageResourceResult.wrap(item)
          }.toList
        )
    override val topResources
        : Optional[List[zio.aws.guardduty.model.UsageResourceResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.guardduty.model.UsageResourceResult.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.UsageStatistics
  ): zio.aws.guardduty.model.UsageStatistics.ReadOnly = new Wrapper(impl)
}
