package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Volume(
    name: Optional[String] = Optional.Absent,
    hostPath: Optional[zio.aws.guardduty.model.HostPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.Volume
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(hostPath.map(value => value.buildAwsValue()))(_.hostPath)
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.Volume.ReadOnly =
    zio.aws.guardduty.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.guardduty.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.Volume = zio.aws.guardduty.model
      .Volume(name.map(value => value), hostPath.map(value => value.asEditable))
    def name: Optional[String]
    def hostPath: Optional[zio.aws.guardduty.model.HostPath.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getHostPath
        : ZIO[Any, AwsError, zio.aws.guardduty.model.HostPath.ReadOnly] =
      AwsError.unwrapOptionField("hostPath", hostPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.Volume
  ) extends zio.aws.guardduty.model.Volume.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val hostPath: Optional[zio.aws.guardduty.model.HostPath.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostPath())
        .map(value => zio.aws.guardduty.model.HostPath.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.Volume
  ): zio.aws.guardduty.model.Volume.ReadOnly = new Wrapper(impl)
}
