package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.guardduty.model.primitives.Integer
import scala.jdk.CollectionConverters.*
final case class VolumeDetail(
    volumeArn: Optional[String] = Optional.Absent,
    volumeType: Optional[String] = Optional.Absent,
    deviceName: Optional[String] = Optional.Absent,
    volumeSizeInGB: Optional[Integer] = Optional.Absent,
    encryptionType: Optional[String] = Optional.Absent,
    snapshotArn: Optional[String] = Optional.Absent,
    kmsKeyArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.VolumeDetail = {
    import VolumeDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.VolumeDetail
      .builder()
      .optionallyWith(volumeArn.map(value => value: java.lang.String))(
        _.volumeArn
      )
      .optionallyWith(volumeType.map(value => value: java.lang.String))(
        _.volumeType
      )
      .optionallyWith(deviceName.map(value => value: java.lang.String))(
        _.deviceName
      )
      .optionallyWith(volumeSizeInGB.map(value => value: java.lang.Integer))(
        _.volumeSizeInGB
      )
      .optionallyWith(encryptionType.map(value => value: java.lang.String))(
        _.encryptionType
      )
      .optionallyWith(snapshotArn.map(value => value: java.lang.String))(
        _.snapshotArn
      )
      .optionallyWith(kmsKeyArn.map(value => value: java.lang.String))(
        _.kmsKeyArn
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.VolumeDetail.ReadOnly =
    zio.aws.guardduty.model.VolumeDetail.wrap(buildAwsValue())
}
object VolumeDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.VolumeDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.VolumeDetail =
      zio.aws.guardduty.model.VolumeDetail(
        volumeArn.map(value => value),
        volumeType.map(value => value),
        deviceName.map(value => value),
        volumeSizeInGB.map(value => value),
        encryptionType.map(value => value),
        snapshotArn.map(value => value),
        kmsKeyArn.map(value => value)
      )
    def volumeArn: Optional[String]
    def volumeType: Optional[String]
    def deviceName: Optional[String]
    def volumeSizeInGB: Optional[Integer]
    def encryptionType: Optional[String]
    def snapshotArn: Optional[String]
    def kmsKeyArn: Optional[String]
    def getVolumeArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeArn", volumeArn)
    def getVolumeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeType", volumeType)
    def getDeviceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getVolumeSizeInGB: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSizeInGB", volumeSizeInGB)
    def getEncryptionType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("encryptionType", encryptionType)
    def getSnapshotArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotArn", snapshotArn)
    def getKmsKeyArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.VolumeDetail
  ) extends zio.aws.guardduty.model.VolumeDetail.ReadOnly {
    override val volumeArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeArn())
      .map(value => value: String)
    override val volumeType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeType())
      .map(value => value: String)
    override val deviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => value: String)
    override val volumeSizeInGB: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSizeInGB())
      .map(value => value: Integer)
    override val encryptionType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.encryptionType())
      .map(value => value: String)
    override val snapshotArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotArn())
      .map(value => value: String)
    override val kmsKeyArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.VolumeDetail
  ): zio.aws.guardduty.model.VolumeDetail.ReadOnly = new Wrapper(impl)
}
