package zio.aws.guardduty.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VolumeMount(
    name: Optional[String] = Optional.Absent,
    mountPath: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.guardduty.model.VolumeMount = {
    import VolumeMount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.guardduty.model.VolumeMount
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(mountPath.map(value => value: java.lang.String))(
        _.mountPath
      )
      .build()
  }
  def asReadOnly: zio.aws.guardduty.model.VolumeMount.ReadOnly =
    zio.aws.guardduty.model.VolumeMount.wrap(buildAwsValue())
}
object VolumeMount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.guardduty.model.VolumeMount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.guardduty.model.VolumeMount =
      zio.aws.guardduty.model
        .VolumeMount(name.map(value => value), mountPath.map(value => value))
    def name: Optional[String]
    def mountPath: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMountPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("mountPath", mountPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.guardduty.model.VolumeMount
  ) extends zio.aws.guardduty.model.VolumeMount.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val mountPath: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.mountPath())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.guardduty.model.VolumeMount
  ): zio.aws.guardduty.model.VolumeMount.ReadOnly = new Wrapper(impl)
}
