package zio.aws.guardduty
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.guardduty.model.primitives.{
  AccountId,
  FilterName,
  DetectorId,
  TagValue,
  FindingType,
  Integer,
  FindingId,
  TagKey
}
import zio.aws.guardduty.model.primitives.DetectorId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.guardduty.model.primitives.AccountId.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.guardduty.model.primitives.ClientToken.Type
    object DetectorId extends Subtype[String]
    type DetectorId = zio.aws.guardduty.model.primitives.DetectorId.Type
    object Email extends Subtype[String]
    type Email = zio.aws.guardduty.model.primitives.Email.Type
    object FilterDescription extends Subtype[String]
    type FilterDescription =
      zio.aws.guardduty.model.primitives.FilterDescription.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.guardduty.model.primitives.FilterName.Type
    object FilterRank extends Subtype[Int]
    type FilterRank = zio.aws.guardduty.model.primitives.FilterRank.Type
    object FindingId extends Subtype[String]
    type FindingId = zio.aws.guardduty.model.primitives.FindingId.Type
    object FindingType extends Subtype[String]
    type FindingType = zio.aws.guardduty.model.primitives.FindingType.Type
    object GuardDutyArn extends Subtype[String]
    type GuardDutyArn = zio.aws.guardduty.model.primitives.GuardDutyArn.Type
    object InstanceArn extends Subtype[String]
    type InstanceArn = zio.aws.guardduty.model.primitives.InstanceArn.Type
    type Integer = Int
    object IntegerValueWithMax extends Subtype[Int]
    type IntegerValueWithMax =
      zio.aws.guardduty.model.primitives.IntegerValueWithMax.Type
    object Location extends Subtype[String]
    type Location = zio.aws.guardduty.model.primitives.Location.Type
    type LongValue = Long
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.guardduty.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.guardduty.model.primitives.Name.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.guardduty.model.primitives.NonEmptyString.Type
    object PositiveLong extends Subtype[Long]
    type PositiveLong = zio.aws.guardduty.model.primitives.PositiveLong.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.guardduty.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.guardduty.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.guardduty.model.primitives.Timestamp.Type
  }
  type AccountDetails = List[zio.aws.guardduty.model.AccountDetail]
  type AccountFreeTrialInfos =
    List[zio.aws.guardduty.model.AccountFreeTrialInfo]
  type AccountIds = List[AccountId]
  type AdminAccounts = List[zio.aws.guardduty.model.AdminAccount]
  type AffectedResources = Map[String, String]
  type Containers = List[zio.aws.guardduty.model.Container]
  type CountBySeverity = Map[String, Integer]
  type Criterion = Map[String, zio.aws.guardduty.model.Condition]
  type DataSourceList = List[zio.aws.guardduty.model.DataSource]
  type Destinations = List[zio.aws.guardduty.model.Destination]
  type DetectorIds = List[DetectorId]
  type Eq = List[String]
  type Equals = List[String]
  type FilePaths = List[zio.aws.guardduty.model.ScanFilePath]
  type FilterCriterionList = List[zio.aws.guardduty.model.FilterCriterion]
  type FilterNames = List[FilterName]
  type FindingIds = List[FindingId]
  type FindingStatisticTypes =
    List[zio.aws.guardduty.model.FindingStatisticType]
  type FindingTypes = List[FindingType]
  type Findings = List[zio.aws.guardduty.model.Finding]
  type Groups = List[String]
  type Invitations = List[zio.aws.guardduty.model.Invitation]
  type IpSetIds = List[String]
  type Ipv6Addresses = List[String]
  type MapEquals = List[zio.aws.guardduty.model.ScanConditionPair]
  type MemberDataSourceConfigurations =
    List[zio.aws.guardduty.model.MemberDataSourceConfiguration]
  type Members = List[zio.aws.guardduty.model.Member]
  type Neq = List[String]
  type NetworkInterfaces = List[zio.aws.guardduty.model.NetworkInterface]
  type NotEquals = List[String]
  type PortProbeDetails = List[zio.aws.guardduty.model.PortProbeDetail]
  type PrivateIpAddresses =
    List[zio.aws.guardduty.model.PrivateIpAddressDetails]
  type ProductCodes = List[zio.aws.guardduty.model.ProductCode]
  type ResourceList = List[String]
  type S3BucketDetails = List[zio.aws.guardduty.model.S3BucketDetail]
  type ScanCriterion = Map[
    zio.aws.guardduty.model.ScanCriterionKey,
    zio.aws.guardduty.model.ScanCondition
  ]
  type ScanThreatNames = List[zio.aws.guardduty.model.ScanThreatName]
  type Scans = List[zio.aws.guardduty.model.Scan]
  type SecurityGroups = List[zio.aws.guardduty.model.SecurityGroup]
  type SourceIps = List[String]
  type Sources = List[String]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type Tags = List[zio.aws.guardduty.model.Tag]
  type ThreatIntelSetIds = List[String]
  type ThreatIntelligenceDetails =
    List[zio.aws.guardduty.model.ThreatIntelligenceDetail]
  type ThreatNames = List[String]
  type UnprocessedAccounts = List[zio.aws.guardduty.model.UnprocessedAccount]
  type UsageAccountResultList = List[zio.aws.guardduty.model.UsageAccountResult]
  type UsageDataSourceResultList =
    List[zio.aws.guardduty.model.UsageDataSourceResult]
  type UsageResourceResultList =
    List[zio.aws.guardduty.model.UsageResourceResult]
  type VolumeDetails = List[zio.aws.guardduty.model.VolumeDetail]
  type VolumeMounts = List[zio.aws.guardduty.model.VolumeMount]
  type Volumes = List[zio.aws.guardduty.model.Volume]
}
