package zio.aws.health
import zio.aws.core.config.AwsConfig
import zio.aws.health.model.Event.ReadOnly
import zio.aws.health.model.{
  DescribeAffectedEntitiesForOrganizationRequest,
  DescribeAffectedEntitiesRequest,
  DescribeEventDetailsForOrganizationRequest,
  DescribeEventAggregatesRequest,
  DescribeEventsRequest,
  DescribeEventDetailsRequest,
  DescribeEventTypesRequest,
  DescribeEventsForOrganizationRequest,
  DescribeAffectedAccountsForOrganizationRequest,
  DescribeEntityAggregatesRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.health.paginators.{
  DescribeAffectedEntitiesPublisher,
  DescribeAffectedEntitiesForOrganizationPublisher,
  DescribeEventAggregatesPublisher,
  DescribeEventsForOrganizationPublisher,
  DescribeAffectedAccountsForOrganizationPublisher,
  DescribeEventTypesPublisher,
  DescribeEventsPublisher
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.health.model.{
  DisableHealthServiceAccessForOrganizationResponse,
  DescribeEventsResponse,
  DescribeAffectedEntitiesResponse,
  DescribeEventAggregatesResponse,
  DescribeAffectedEntitiesForOrganizationResponse,
  DescribeEventTypesResponse,
  OrganizationEvent,
  EventAggregate,
  AffectedEntity,
  DescribeHealthServiceStatusForOrganizationResponse,
  EventType,
  EnableHealthServiceAccessForOrganizationRequest,
  DisableHealthServiceAccessForOrganizationRequest,
  DescribeEventDetailsResponse,
  DescribeEntityAggregatesResponse,
  Event,
  DescribeEventsForOrganizationResponse,
  DescribeHealthServiceStatusForOrganizationRequest,
  DescribeAffectedAccountsForOrganizationResponse,
  EnableHealthServiceAccessForOrganizationResponse,
  DescribeEventDetailsForOrganizationResponse
}
import software.amazon.awssdk.services.health.{
  HealthAsyncClientBuilder,
  HealthAsyncClient
}
import zio.stream.ZStream
import zio.aws.health.model.primitives.AccountId
import scala.jdk.CollectionConverters._
trait Health extends AspectSupport[Health] {
  val api: HealthAsyncClient
  def describeEventDetailsForOrganization(
      request: DescribeEventDetailsForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly
  ]
  def describeAffectedEntitiesForOrganization(
      request: DescribeAffectedEntitiesForOrganizationRequest
  ): ZStream[Any, AwsError, zio.aws.health.model.AffectedEntity.ReadOnly]
  def describeAffectedEntitiesForOrganizationPaginated(
      request: DescribeAffectedEntitiesForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly
  ]
  def describeEventTypes(
      request: DescribeEventTypesRequest
  ): ZStream[Any, AwsError, zio.aws.health.model.EventType.ReadOnly]
  def describeEventTypesPaginated(
      request: DescribeEventTypesRequest
  ): IO[AwsError, zio.aws.health.model.DescribeEventTypesResponse.ReadOnly]
  def describeEventDetails(
      request: DescribeEventDetailsRequest
  ): IO[AwsError, zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly]
  def describeEntityAggregates(request: DescribeEntityAggregatesRequest): IO[
    AwsError,
    zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly
  ]
  def describeHealthServiceStatusForOrganization(): IO[
    AwsError,
    zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly
  ]
  def enableHealthServiceAccessForOrganization(): IO[AwsError, Unit]
  def disableHealthServiceAccessForOrganization(): IO[AwsError, Unit]
  def describeAffectedEntities(
      request: DescribeAffectedEntitiesRequest
  ): ZStream[Any, AwsError, zio.aws.health.model.AffectedEntity.ReadOnly]
  def describeAffectedEntitiesPaginated(
      request: DescribeAffectedEntitiesRequest
  ): IO[
    AwsError,
    zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly
  ]
  def describeEventAggregates(
      request: DescribeEventAggregatesRequest
  ): ZStream[Any, AwsError, zio.aws.health.model.EventAggregate.ReadOnly]
  def describeEventAggregatesPaginated(
      request: DescribeEventAggregatesRequest
  ): IO[AwsError, zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly]
  def describeAffectedAccountsForOrganization(
      request: DescribeAffectedAccountsForOrganizationRequest
  ): ZStream[Any, AwsError, AccountId]
  def describeAffectedAccountsForOrganizationPaginated(
      request: DescribeAffectedAccountsForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly
  ]
  def describeEventsForOrganization(
      request: DescribeEventsForOrganizationRequest
  ): ZStream[Any, AwsError, zio.aws.health.model.OrganizationEvent.ReadOnly]
  def describeEventsForOrganizationPaginated(
      request: DescribeEventsForOrganizationRequest
  ): IO[
    AwsError,
    zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly
  ]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.health.model.DescribeEventsResponse.ReadOnly]
}
object Health {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Health] = customized(
    identity
  )
  def customized(
      customization: HealthAsyncClientBuilder => HealthAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Health] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: HealthAsyncClientBuilder => HealthAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Health] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = HealthAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[HealthAsyncClient, HealthAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[HealthAsyncClient, HealthAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new HealthImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class HealthImpl[R](
      override val api: HealthAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Health
      with AwsServiceBase[R] {
    override val serviceName: String = "Health"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): HealthImpl[R1] = new HealthImpl(api, newAspect, r)
    def describeEventDetailsForOrganization(
        request: DescribeEventDetailsForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeEventDetailsForOrganizationRequest,
      DescribeEventDetailsForOrganizationResponse
    ](
      "describeEventDetailsForOrganization",
      api.describeEventDetailsForOrganization
    )(request.buildAwsValue())
      .map(
        zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def describeAffectedEntitiesForOrganization(
        request: DescribeAffectedEntitiesForOrganizationRequest
    ): ZStream[Any, AwsError, zio.aws.health.model.AffectedEntity.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest,
        AffectedEntity,
        DescribeAffectedEntitiesForOrganizationPublisher
      ](
        "describeAffectedEntitiesForOrganization",
        api.describeAffectedEntitiesForOrganizationPaginator,
        _.entities()
      )(request.buildAwsValue())
        .map(item => zio.aws.health.model.AffectedEntity.wrap(item))
        .provideEnvironment(r)
    def describeAffectedEntitiesForOrganizationPaginated(
        request: DescribeAffectedEntitiesForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest,
      DescribeAffectedEntitiesForOrganizationResponse
    ](
      "describeAffectedEntitiesForOrganization",
      api.describeAffectedEntitiesForOrganization
    )(request.buildAwsValue())
      .map(
        zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def describeEventTypes(
        request: DescribeEventTypesRequest
    ): ZStream[Any, AwsError, zio.aws.health.model.EventType.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.health.model.DescribeEventTypesRequest,
        EventType,
        DescribeEventTypesPublisher
      ]("describeEventTypes", api.describeEventTypesPaginator, _.eventTypes())(
        request.buildAwsValue()
      ).map(item => zio.aws.health.model.EventType.wrap(item))
        .provideEnvironment(r)
    def describeEventTypesPaginated(
        request: DescribeEventTypesRequest
    ): IO[AwsError, zio.aws.health.model.DescribeEventTypesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.health.model.DescribeEventTypesRequest,
        DescribeEventTypesResponse
      ]("describeEventTypes", api.describeEventTypes)(request.buildAwsValue())
        .map(zio.aws.health.model.DescribeEventTypesResponse.wrap)
        .provideEnvironment(r)
    def describeEventDetails(request: DescribeEventDetailsRequest): IO[
      AwsError,
      zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeEventDetailsRequest,
      DescribeEventDetailsResponse
    ]("describeEventDetails", api.describeEventDetails)(request.buildAwsValue())
      .map(zio.aws.health.model.DescribeEventDetailsResponse.wrap)
      .provideEnvironment(r)
    def describeEntityAggregates(request: DescribeEntityAggregatesRequest): IO[
      AwsError,
      zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeEntityAggregatesRequest,
      DescribeEntityAggregatesResponse
    ]("describeEntityAggregates", api.describeEntityAggregates)(
      request.buildAwsValue()
    ).map(zio.aws.health.model.DescribeEntityAggregatesResponse.wrap)
      .provideEnvironment(r)
    def describeHealthServiceStatusForOrganization(): IO[
      AwsError,
      zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeHealthServiceStatusForOrganizationRequest,
      DescribeHealthServiceStatusForOrganizationResponse
    ](
      "describeHealthServiceStatusForOrganization",
      api.describeHealthServiceStatusForOrganization
    )(DescribeHealthServiceStatusForOrganizationRequest.builder().build())
      .map(
        zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def enableHealthServiceAccessForOrganization(): IO[AwsError, Unit] =
      asyncRequestResponse[
        EnableHealthServiceAccessForOrganizationRequest,
        EnableHealthServiceAccessForOrganizationResponse
      ](
        "enableHealthServiceAccessForOrganization",
        api.enableHealthServiceAccessForOrganization
      )(EnableHealthServiceAccessForOrganizationRequest.builder().build()).unit
        .provideEnvironment(r)
    def disableHealthServiceAccessForOrganization(): IO[AwsError, Unit] =
      asyncRequestResponse[
        DisableHealthServiceAccessForOrganizationRequest,
        DisableHealthServiceAccessForOrganizationResponse
      ](
        "disableHealthServiceAccessForOrganization",
        api.disableHealthServiceAccessForOrganization
      )(DisableHealthServiceAccessForOrganizationRequest.builder().build()).unit
        .provideEnvironment(r)
    def describeAffectedEntities(
        request: DescribeAffectedEntitiesRequest
    ): ZStream[Any, AwsError, zio.aws.health.model.AffectedEntity.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest,
        AffectedEntity,
        DescribeAffectedEntitiesPublisher
      ](
        "describeAffectedEntities",
        api.describeAffectedEntitiesPaginator,
        _.entities()
      )(request.buildAwsValue())
        .map(item => zio.aws.health.model.AffectedEntity.wrap(item))
        .provideEnvironment(r)
    def describeAffectedEntitiesPaginated(
        request: DescribeAffectedEntitiesRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest,
      DescribeAffectedEntitiesResponse
    ]("describeAffectedEntities", api.describeAffectedEntities)(
      request.buildAwsValue()
    ).map(zio.aws.health.model.DescribeAffectedEntitiesResponse.wrap)
      .provideEnvironment(r)
    def describeEventAggregates(
        request: DescribeEventAggregatesRequest
    ): ZStream[Any, AwsError, zio.aws.health.model.EventAggregate.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest,
        EventAggregate,
        DescribeEventAggregatesPublisher
      ](
        "describeEventAggregates",
        api.describeEventAggregatesPaginator,
        _.eventAggregates()
      )(request.buildAwsValue())
        .map(item => zio.aws.health.model.EventAggregate.wrap(item))
        .provideEnvironment(r)
    def describeEventAggregatesPaginated(
        request: DescribeEventAggregatesRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeEventAggregatesRequest,
      DescribeEventAggregatesResponse
    ]("describeEventAggregates", api.describeEventAggregates)(
      request.buildAwsValue()
    ).map(zio.aws.health.model.DescribeEventAggregatesResponse.wrap)
      .provideEnvironment(r)
    def describeAffectedAccountsForOrganization(
        request: DescribeAffectedAccountsForOrganizationRequest
    ): ZStream[Any, AwsError, AccountId] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest,
      java.lang.String,
      DescribeAffectedAccountsForOrganizationPublisher
    ](
      "describeAffectedAccountsForOrganization",
      api.describeAffectedAccountsForOrganizationPaginator,
      _.affectedAccounts()
    )(request.buildAwsValue())
      .map(item => zio.aws.health.model.primitives.AccountId(item))
      .provideEnvironment(r)
    def describeAffectedAccountsForOrganizationPaginated(
        request: DescribeAffectedAccountsForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest,
      DescribeAffectedAccountsForOrganizationResponse
    ](
      "describeAffectedAccountsForOrganization",
      api.describeAffectedAccountsForOrganization
    )(request.buildAwsValue())
      .map(
        zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.wrap
      )
      .provideEnvironment(r)
    def describeEventsForOrganization(
        request: DescribeEventsForOrganizationRequest
    ): ZStream[Any, AwsError, zio.aws.health.model.OrganizationEvent.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest,
        OrganizationEvent,
        DescribeEventsForOrganizationPublisher
      ](
        "describeEventsForOrganization",
        api.describeEventsForOrganizationPaginator,
        _.events()
      )(request.buildAwsValue())
        .map(item => zio.aws.health.model.OrganizationEvent.wrap(item))
        .provideEnvironment(r)
    def describeEventsForOrganizationPaginated(
        request: DescribeEventsForOrganizationRequest
    ): IO[
      AwsError,
      zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest,
      DescribeEventsForOrganizationResponse
    ]("describeEventsForOrganization", api.describeEventsForOrganization)(
      request.buildAwsValue()
    ).map(zio.aws.health.model.DescribeEventsForOrganizationResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.health.model.DescribeEventsRequest,
      Event,
      DescribeEventsPublisher
    ]("describeEvents", api.describeEventsPaginator, _.events())(
      request.buildAwsValue()
    ).map(item => zio.aws.health.model.Event.wrap(item)).provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.health.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.health.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.health.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
  }
  def describeEventDetailsForOrganization(
      request: DescribeEventDetailsForOrganizationRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventDetailsForOrganization(request))
  def describeAffectedEntitiesForOrganization(
      request: DescribeAffectedEntitiesForOrganizationRequest
  ): ZStream[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.AffectedEntity.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeAffectedEntitiesForOrganization(request)
  )
  def describeAffectedEntitiesForOrganizationPaginated(
      request: DescribeAffectedEntitiesForOrganizationRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeAffectedEntitiesForOrganizationPaginated(request)
  )
  def describeEventTypes(request: DescribeEventTypesRequest): ZStream[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.EventType.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventTypes(request))
  def describeEventTypesPaginated(request: DescribeEventTypesRequest): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventTypesPaginated(request))
  def describeEventDetails(request: DescribeEventDetailsRequest): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventDetails(request))
  def describeEntityAggregates(request: DescribeEntityAggregatesRequest): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEntityAggregates(request))
  def describeHealthServiceStatusForOrganization(): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHealthServiceStatusForOrganization())
  def enableHealthServiceAccessForOrganization()
      : ZIO[zio.aws.health.Health, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableHealthServiceAccessForOrganization())
  def disableHealthServiceAccessForOrganization()
      : ZIO[zio.aws.health.Health, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableHealthServiceAccessForOrganization())
  def describeAffectedEntities(
      request: DescribeAffectedEntitiesRequest
  ): ZStream[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.AffectedEntity.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAffectedEntities(request))
  def describeAffectedEntitiesPaginated(
      request: DescribeAffectedEntitiesRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAffectedEntitiesPaginated(request))
  def describeEventAggregates(request: DescribeEventAggregatesRequest): ZStream[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.EventAggregate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventAggregates(request))
  def describeEventAggregatesPaginated(
      request: DescribeEventAggregatesRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventAggregatesPaginated(request))
  def describeAffectedAccountsForOrganization(
      request: DescribeAffectedAccountsForOrganizationRequest
  ): ZStream[zio.aws.health.Health, AwsError, AccountId] =
    ZStream.serviceWithStream(
      _.describeAffectedAccountsForOrganization(request)
    )
  def describeAffectedAccountsForOrganizationPaginated(
      request: DescribeAffectedAccountsForOrganizationRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeAffectedAccountsForOrganizationPaginated(request)
  )
  def describeEventsForOrganization(
      request: DescribeEventsForOrganizationRequest
  ): ZStream[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.OrganizationEvent.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventsForOrganization(request))
  def describeEventsForOrganizationPaginated(
      request: DescribeEventsForOrganizationRequest
  ): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsForOrganizationPaginated(request))
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[zio.aws.health.Health, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.health.Health,
    AwsError,
    zio.aws.health.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
}
