package zio.aws.health
import zio.mock.{Proxy, Mock}
import zio.aws.health.model.Event.ReadOnly
import zio.aws.health.model.{
  DescribeAffectedEntitiesForOrganizationRequest,
  DescribeAffectedEntitiesRequest,
  DescribeEventDetailsForOrganizationRequest,
  DescribeEventAggregatesRequest,
  DescribeEventsRequest,
  DescribeEventDetailsRequest,
  DescribeEventTypesRequest,
  DescribeEventsForOrganizationRequest,
  DescribeAffectedAccountsForOrganizationRequest,
  DescribeEntityAggregatesRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.health.HealthAsyncClient
import zio.stream.ZStream
import zio.aws.health.model.primitives.AccountId
object HealthMock extends Mock[Health] {
  object DescribeEventDetailsForOrganization
      extends Effect[
        DescribeEventDetailsForOrganizationRequest,
        AwsError,
        zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly
      ]
  object DescribeAffectedEntitiesForOrganization
      extends Stream[
        DescribeAffectedEntitiesForOrganizationRequest,
        AwsError,
        zio.aws.health.model.AffectedEntity.ReadOnly
      ]
  object DescribeAffectedEntitiesForOrganizationPaginated
      extends Effect[
        DescribeAffectedEntitiesForOrganizationRequest,
        AwsError,
        zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly
      ]
  object DescribeEventTypes
      extends Stream[
        DescribeEventTypesRequest,
        AwsError,
        zio.aws.health.model.EventType.ReadOnly
      ]
  object DescribeEventTypesPaginated
      extends Effect[
        DescribeEventTypesRequest,
        AwsError,
        zio.aws.health.model.DescribeEventTypesResponse.ReadOnly
      ]
  object DescribeEventDetails
      extends Effect[
        DescribeEventDetailsRequest,
        AwsError,
        zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly
      ]
  object DescribeEntityAggregates
      extends Effect[
        DescribeEntityAggregatesRequest,
        AwsError,
        zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly
      ]
  object DescribeHealthServiceStatusForOrganization
      extends Effect[
        Unit,
        AwsError,
        zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly
      ]
  object EnableHealthServiceAccessForOrganization
      extends Effect[Unit, AwsError, Unit]
  object DisableHealthServiceAccessForOrganization
      extends Effect[Unit, AwsError, Unit]
  object DescribeAffectedEntities
      extends Stream[
        DescribeAffectedEntitiesRequest,
        AwsError,
        zio.aws.health.model.AffectedEntity.ReadOnly
      ]
  object DescribeAffectedEntitiesPaginated
      extends Effect[
        DescribeAffectedEntitiesRequest,
        AwsError,
        zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly
      ]
  object DescribeEventAggregates
      extends Stream[
        DescribeEventAggregatesRequest,
        AwsError,
        zio.aws.health.model.EventAggregate.ReadOnly
      ]
  object DescribeEventAggregatesPaginated
      extends Effect[
        DescribeEventAggregatesRequest,
        AwsError,
        zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly
      ]
  object DescribeAffectedAccountsForOrganization
      extends Stream[
        DescribeAffectedAccountsForOrganizationRequest,
        AwsError,
        AccountId
      ]
  object DescribeAffectedAccountsForOrganizationPaginated
      extends Effect[
        DescribeAffectedAccountsForOrganizationRequest,
        AwsError,
        zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly
      ]
  object DescribeEventsForOrganization
      extends Stream[
        DescribeEventsForOrganizationRequest,
        AwsError,
        zio.aws.health.model.OrganizationEvent.ReadOnly
      ]
  object DescribeEventsForOrganizationPaginated
      extends Effect[
        DescribeEventsForOrganizationRequest,
        AwsError,
        zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[DescribeEventsRequest, AwsError, ReadOnly]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.health.model.DescribeEventsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Health] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Health] { rts =>
        zio.ZIO.succeed {
          new Health {
            val api: HealthAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Health = this
            def describeEventDetailsForOrganization(
                request: DescribeEventDetailsForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeEventDetailsForOrganizationResponse.ReadOnly
            ] = proxy(DescribeEventDetailsForOrganization, request)
            def describeAffectedEntitiesForOrganization(
                request: DescribeAffectedEntitiesForOrganizationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.health.model.AffectedEntity.ReadOnly
            ] = rts.unsafeRun(
              proxy(DescribeAffectedEntitiesForOrganization, request)
            )
            def describeAffectedEntitiesForOrganizationPaginated(
                request: DescribeAffectedEntitiesForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly
            ] = proxy(DescribeAffectedEntitiesForOrganizationPaginated, request)
            def describeEventTypes(
                request: DescribeEventTypesRequest
            ): ZStream[Any, AwsError, zio.aws.health.model.EventType.ReadOnly] =
              rts.unsafeRun(proxy(DescribeEventTypes, request))
            def describeEventTypesPaginated(
                request: DescribeEventTypesRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeEventTypesResponse.ReadOnly
            ] = proxy(DescribeEventTypesPaginated, request)
            def describeEventDetails(request: DescribeEventDetailsRequest): IO[
              AwsError,
              zio.aws.health.model.DescribeEventDetailsResponse.ReadOnly
            ] = proxy(DescribeEventDetails, request)
            def describeEntityAggregates(
                request: DescribeEntityAggregatesRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeEntityAggregatesResponse.ReadOnly
            ] = proxy(DescribeEntityAggregates, request)
            def describeHealthServiceStatusForOrganization(): IO[
              AwsError,
              zio.aws.health.model.DescribeHealthServiceStatusForOrganizationResponse.ReadOnly
            ] = proxy(DescribeHealthServiceStatusForOrganization)
            def enableHealthServiceAccessForOrganization(): IO[AwsError, Unit] =
              proxy(EnableHealthServiceAccessForOrganization)
            def disableHealthServiceAccessForOrganization()
                : IO[AwsError, Unit] =
              proxy(DisableHealthServiceAccessForOrganization)
            def describeAffectedEntities(
                request: DescribeAffectedEntitiesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.health.model.AffectedEntity.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeAffectedEntities, request))
            def describeAffectedEntitiesPaginated(
                request: DescribeAffectedEntitiesRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeAffectedEntitiesResponse.ReadOnly
            ] = proxy(DescribeAffectedEntitiesPaginated, request)
            def describeEventAggregates(
                request: DescribeEventAggregatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.health.model.EventAggregate.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeEventAggregates, request))
            def describeEventAggregatesPaginated(
                request: DescribeEventAggregatesRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeEventAggregatesResponse.ReadOnly
            ] = proxy(DescribeEventAggregatesPaginated, request)
            def describeAffectedAccountsForOrganization(
                request: DescribeAffectedAccountsForOrganizationRequest
            ): ZStream[Any, AwsError, AccountId] = rts.unsafeRun(
              proxy(DescribeAffectedAccountsForOrganization, request)
            )
            def describeAffectedAccountsForOrganizationPaginated(
                request: DescribeAffectedAccountsForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly
            ] = proxy(DescribeAffectedAccountsForOrganizationPaginated, request)
            def describeEventsForOrganization(
                request: DescribeEventsForOrganizationRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.health.model.OrganizationEvent.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeEventsForOrganization, request))
            def describeEventsForOrganizationPaginated(
                request: DescribeEventsForOrganizationRequest
            ): IO[
              AwsError,
              zio.aws.health.model.DescribeEventsForOrganizationResponse.ReadOnly
            ] = proxy(DescribeEventsForOrganizationPaginated, request)
            def describeEvents(
                request: DescribeEventsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              rts.unsafeRun(proxy(DescribeEvents, request))
            def describeEventsPaginated(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.health.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEventsPaginated, request)
          }
        }
      }
    }
  }
}
