package zio.aws.health.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{
  EntityValue,
  AccountId,
  Timestamp,
  EntityArn,
  TagValue,
  EventArn,
  TagKey,
  EntityUrl
}
import scala.jdk.CollectionConverters._
final case class AffectedEntity(
    entityArn: Optional[EntityArn] = Optional.Absent,
    eventArn: Optional[EventArn] = Optional.Absent,
    entityValue: Optional[EntityValue] = Optional.Absent,
    entityUrl: Optional[EntityUrl] = Optional.Absent,
    awsAccountId: Optional[AccountId] = Optional.Absent,
    lastUpdatedTime: Optional[Timestamp] = Optional.Absent,
    statusCode: Optional[zio.aws.health.model.EntityStatusCode] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.AffectedEntity = {
    import AffectedEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.AffectedEntity
      .builder()
      .optionallyWith(
        entityArn.map(value => EntityArn.unwrap(value): java.lang.String)
      )(_.entityArn)
      .optionallyWith(
        eventArn.map(value => EventArn.unwrap(value): java.lang.String)
      )(_.eventArn)
      .optionallyWith(
        entityValue.map(value => EntityValue.unwrap(value): java.lang.String)
      )(_.entityValue)
      .optionallyWith(
        entityUrl.map(value => EntityUrl.unwrap(value): java.lang.String)
      )(_.entityUrl)
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        lastUpdatedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.health.model.AffectedEntity.ReadOnly =
    zio.aws.health.model.AffectedEntity.wrap(buildAwsValue())
}
object AffectedEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.AffectedEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.AffectedEntity =
      zio.aws.health.model.AffectedEntity(
        entityArn.map(value => value),
        eventArn.map(value => value),
        entityValue.map(value => value),
        entityUrl.map(value => value),
        awsAccountId.map(value => value),
        lastUpdatedTime.map(value => value),
        statusCode.map(value => value),
        tags.map(value => value)
      )
    def entityArn: Optional[EntityArn]
    def eventArn: Optional[EventArn]
    def entityValue: Optional[EntityValue]
    def entityUrl: Optional[EntityUrl]
    def awsAccountId: Optional[AccountId]
    def lastUpdatedTime: Optional[Timestamp]
    def statusCode: Optional[zio.aws.health.model.EntityStatusCode]
    def tags: Optional[Map[TagKey, TagValue]]
    def getEntityArn: ZIO[Any, AwsError, EntityArn] =
      AwsError.unwrapOptionField("entityArn", entityArn)
    def getEventArn: ZIO[Any, AwsError, EventArn] =
      AwsError.unwrapOptionField("eventArn", eventArn)
    def getEntityValue: ZIO[Any, AwsError, EntityValue] =
      AwsError.unwrapOptionField("entityValue", entityValue)
    def getEntityUrl: ZIO[Any, AwsError, EntityUrl] =
      AwsError.unwrapOptionField("entityUrl", entityUrl)
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getLastUpdatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.health.model.EntityStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.AffectedEntity
  ) extends zio.aws.health.model.AffectedEntity.ReadOnly {
    override val entityArn: Optional[EntityArn] = zio.aws.core.internal
      .optionalFromNullable(impl.entityArn())
      .map(value => zio.aws.health.model.primitives.EntityArn(value))
    override val eventArn: Optional[EventArn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventArn())
      .map(value => zio.aws.health.model.primitives.EventArn(value))
    override val entityValue: Optional[EntityValue] = zio.aws.core.internal
      .optionalFromNullable(impl.entityValue())
      .map(value => zio.aws.health.model.primitives.EntityValue(value))
    override val entityUrl: Optional[EntityUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.entityUrl())
      .map(value => zio.aws.health.model.primitives.EntityUrl(value))
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.health.model.primitives.AccountId(value))
    override val lastUpdatedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
    override val statusCode: Optional[zio.aws.health.model.EntityStatusCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusCode())
        .map(value => zio.aws.health.model.EntityStatusCode.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.health.model.primitives
              .TagKey(key) -> zio.aws.health.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.AffectedEntity
  ): zio.aws.health.model.AffectedEntity.ReadOnly = new Wrapper(impl)
}
