package zio.aws.health.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class DateTimeRange(
    from: Optional[Timestamp] = Optional.Absent,
    to: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DateTimeRange = {
    import DateTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DateTimeRange
      .builder()
      .optionallyWith(from.map(value => Timestamp.unwrap(value): Instant))(
        _.from
      )
      .optionallyWith(to.map(value => Timestamp.unwrap(value): Instant))(_.to)
      .build()
  }
  def asReadOnly: zio.aws.health.model.DateTimeRange.ReadOnly =
    zio.aws.health.model.DateTimeRange.wrap(buildAwsValue())
}
object DateTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DateTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DateTimeRange = zio.aws.health.model
      .DateTimeRange(from.map(value => value), to.map(value => value))
    def from: Optional[Timestamp]
    def to: Optional[Timestamp]
    def getFrom: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("from", from)
    def getTo: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("to", to)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DateTimeRange
  ) extends zio.aws.health.model.DateTimeRange.ReadOnly {
    override val from: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.from())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
    override val to: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.to())
      .map(value => zio.aws.health.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DateTimeRange
  ): zio.aws.health.model.DateTimeRange.ReadOnly = new Wrapper(impl)
}
