package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{MaxResults, NextToken, EventArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAffectedAccountsForOrganizationRequest(
    eventArn: EventArn,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest = {
    import DescribeAffectedAccountsForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest
      .builder()
      .eventArn(EventArn.unwrap(eventArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest.ReadOnly =
    zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest
      .wrap(buildAwsValue())
}
object DescribeAffectedAccountsForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest =
      zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest(
        eventArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def eventArn: EventArn
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getEventArn: ZIO[Any, Nothing, EventArn] = ZIO.succeed(eventArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest
  ) extends zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest.ReadOnly {
    override val eventArn: EventArn =
      zio.aws.health.model.primitives.EventArn(impl.eventArn())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.health.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationRequest
  ): zio.aws.health.model.DescribeAffectedAccountsForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
