package zio.aws.health.model
import zio.aws.health.model.primitives.{NextToken, AccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAffectedAccountsForOrganizationResponse(
    affectedAccounts: Optional[Iterable[AccountId]] = Optional.Absent,
    eventScopeCode: Optional[zio.aws.health.model.EventScopeCode] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse = {
    import DescribeAffectedAccountsForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse
      .builder()
      .optionallyWith(
        affectedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.affectedAccounts)
      .optionallyWith(eventScopeCode.map(value => value.unwrap))(
        _.eventScopeCode
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly =
    zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse
      .wrap(buildAwsValue())
}
object DescribeAffectedAccountsForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse =
      zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse(
        affectedAccounts.map(value => value),
        eventScopeCode.map(value => value),
        nextToken.map(value => value)
      )
    def affectedAccounts: Optional[List[AccountId]]
    def eventScopeCode: Optional[zio.aws.health.model.EventScopeCode]
    def nextToken: Optional[NextToken]
    def getAffectedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("affectedAccounts", affectedAccounts)
    def getEventScopeCode
        : ZIO[Any, AwsError, zio.aws.health.model.EventScopeCode] =
      AwsError.unwrapOptionField("eventScopeCode", eventScopeCode)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse
  ) extends zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly {
    override val affectedAccounts: Optional[List[AccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.affectedAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.primitives.AccountId(item)
          }.toList
        )
    override val eventScopeCode: Optional[zio.aws.health.model.EventScopeCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventScopeCode())
        .map(value => zio.aws.health.model.EventScopeCode.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedAccountsForOrganizationResponse
  ): zio.aws.health.model.DescribeAffectedAccountsForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
