package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{MaxResultsLowerRange, NextToken, Locale}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAffectedEntitiesForOrganizationRequest(
    organizationEntityFilters: Iterable[
      zio.aws.health.model.EventAccountFilter
    ],
    locale: Optional[Locale] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResultsLowerRange] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest = {
    import DescribeAffectedEntitiesForOrganizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest
      .builder()
      .organizationEntityFilters(organizationEntityFilters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResultsLowerRange.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest.ReadOnly =
    zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest
      .wrap(buildAwsValue())
}
object DescribeAffectedEntitiesForOrganizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest =
      zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest(
        organizationEntityFilters.map { item =>
          item.asEditable
        },
        locale.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def organizationEntityFilters
        : List[zio.aws.health.model.EventAccountFilter.ReadOnly]
    def locale: Optional[Locale]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResultsLowerRange]
    def getOrganizationEntityFilters: ZIO[Any, Nothing, List[
      zio.aws.health.model.EventAccountFilter.ReadOnly
    ]] = ZIO.succeed(organizationEntityFilters)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsLowerRange] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest
  ) extends zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest.ReadOnly {
    override val organizationEntityFilters
        : List[zio.aws.health.model.EventAccountFilter.ReadOnly] = impl
      .organizationEntityFilters()
      .asScala
      .map { item =>
        zio.aws.health.model.EventAccountFilter.wrap(item)
      }
      .toList
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResultsLowerRange] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.health.model.primitives.MaxResultsLowerRange(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationRequest
  ): zio.aws.health.model.DescribeAffectedEntitiesForOrganizationRequest.ReadOnly =
    new Wrapper(impl)
}
