package zio.aws.health.model
import zio.aws.health.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeAffectedEntitiesForOrganizationResponse(
    entities: Optional[Iterable[zio.aws.health.model.AffectedEntity]] =
      Optional.Absent,
    failedSet: Optional[
      Iterable[zio.aws.health.model.OrganizationAffectedEntitiesErrorItem]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse = {
    import DescribeAffectedEntitiesForOrganizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
      .builder()
      .optionallyWith(
        entities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entities)
      .optionallyWith(
        failedSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedSet)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly =
    zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse
      .wrap(buildAwsValue())
}
object DescribeAffectedEntitiesForOrganizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse =
      zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse(
        entities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def entities: Optional[List[zio.aws.health.model.AffectedEntity.ReadOnly]]
    def failedSet: Optional[
      List[zio.aws.health.model.OrganizationAffectedEntitiesErrorItem.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getEntities: ZIO[Any, AwsError, List[
      zio.aws.health.model.AffectedEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entities", entities)
    def getFailedSet: ZIO[Any, AwsError, List[
      zio.aws.health.model.OrganizationAffectedEntitiesErrorItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedSet", failedSet)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
  ) extends zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly {
    override val entities
        : Optional[List[zio.aws.health.model.AffectedEntity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.health.model.AffectedEntity.wrap(item)
          }.toList
        )
    override val failedSet: Optional[
      List[zio.aws.health.model.OrganizationAffectedEntitiesErrorItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.failedSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.health.model.OrganizationAffectedEntitiesErrorItem.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesForOrganizationResponse
  ): zio.aws.health.model.DescribeAffectedEntitiesForOrganizationResponse.ReadOnly =
    new Wrapper(impl)
}
