package zio.aws.health.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.health.model.primitives.{MaxResults, NextToken, Locale}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeAffectedEntitiesRequest(
    filter: zio.aws.health.model.EntityFilter,
    locale: Optional[Locale] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest = {
    import DescribeAffectedEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest
      .builder()
      .filter(filter.buildAwsValue())
      .optionallyWith(
        locale.map(value => Locale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.health.model.DescribeAffectedEntitiesRequest.ReadOnly =
    zio.aws.health.model.DescribeAffectedEntitiesRequest.wrap(buildAwsValue())
}
object DescribeAffectedEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.health.model.DescribeAffectedEntitiesRequest =
      zio.aws.health.model.DescribeAffectedEntitiesRequest(
        filter.asEditable,
        locale.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def filter: zio.aws.health.model.EntityFilter.ReadOnly
    def locale: Optional[Locale]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getFilter
        : ZIO[Any, Nothing, zio.aws.health.model.EntityFilter.ReadOnly] =
      ZIO.succeed(filter)
    def getLocale: ZIO[Any, AwsError, Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest
  ) extends zio.aws.health.model.DescribeAffectedEntitiesRequest.ReadOnly {
    override val filter: zio.aws.health.model.EntityFilter.ReadOnly =
      zio.aws.health.model.EntityFilter.wrap(impl.filter())
    override val locale: Optional[Locale] = zio.aws.core.internal
      .optionalFromNullable(impl.locale())
      .map(value => zio.aws.health.model.primitives.Locale(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.health.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.health.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.health.model.DescribeAffectedEntitiesRequest
  ): zio.aws.health.model.DescribeAffectedEntitiesRequest.ReadOnly =
    new Wrapper(impl)
}
